/*
 *	tar95.c / 4tar.c
 *
 *      Version 0.3
 *
 *	Unix Tape Archive (TAR) Extractor for WIN95 / 4DOS
 *
 */

#include <stdio.h>

#ifdef __WIN32__
   #include <windows.h>
   #define PROGNAME "TAR95"
   #define TARFILE  HFILE
#else
   #include <dir.h>
   #include <dos.h>
   #include <stdlib.h>
   #include <string.h>
   #define PROGNAME "4TAR"
   #define TARFILE  FILE*
#endif

#include "tar.h"





struct S_tar_header tar_header;




TARFILE tar_openfile(char *filename, int write)
{
   TARFILE  fin;
#ifdef __WIN32__
   OFSTRUCT of;
   fin=OpenFile(filename,&of,write?OF_WRITE:OF_READ);
   if (fin!=HFILE_ERROR)
#else
   fin=fopen(filename,write?"wb":"rb");
   if (fin)
#endif
      return fin;
   else
      printf("%s erreur : impossible d'ouvrir l'archive (%s) !\n",PROGNAME,filename);

#ifdef __WIN32__
   return HFILE_ERROR;
#else
   return 0;
#endif
}

void tar_closefile(TARFILE ftar)
{
#ifdef __WIN32__
   _lclose(ftar);
#else
   fclose(ftar);
#endif
}

int tar_readheader(TARFILE ftar, struct S_tar_header *header)
{
   int size,i;

#ifdef __WIN32__
   size=_lread(ftar,header,512);
#else
   size=fread(header,1,512,ftar);
#endif
   if (size==512)
   {
      i=0;
      while (tar_header.name[i])
      {
         if (tar_header.name[i]=='/')
             tar_header.name[i]='\\';
         i++;
      }
      return 1;
   }

   return 0;
}

long tar_chuncksize(struct S_tar_header header)
{
   long size;

   sscanf(header.size,"%O",&size);
   return size;
}

int tar_relative_seek(TARFILE ftar, long size)
{
#ifdef __WIN32__
   return (_llseek(ftar,size+((size%512)?(512-(size%512)):0),SEEK_CUR)!=HFILE_ERROR);
#else
   return (fseek(ftar,size+((size%512)?(512-(size%512)):0),SEEK_CUR)==0);
#endif
}

int tar_adjust_seek(TARFILE ftar, long size)
{
#ifdef __WIN32__
   return (_llseek(ftar,((size%512)?(512-(size%512)):0),SEEK_CUR)!=HFILE_ERROR);
#else
   return (fseek(ftar,((size%512)?(512-(size%512)):0),SEEK_CUR)==0);
#endif
}







#ifdef __WIN32__
int tar_extract(TARFILE ftar)
{
   while (tar_readheader(ftar,&tar_header)&&(tar_header.name[0]!=0))
   {
      printf("%s: ",tar_header.name); fflush(stdout);

      switch (tar_header.linkflag)
      {
         case LF_DIR :
            {
               printf("Cration du rpertoire ..."); fflush(stdout);
               tar_header.name[strlen(tar_header.name)-1]=0;
               if (CreateDirectory(tar_header.name,NULL)==FALSE)
               {
                  printf("4TAR erreur : Erreur de repertoire !\n");
                  return 0;
               }
               printf(" Ok.\n");
            }
            break;

         case LF_OLDNORMAL :
         case LF_NORMAL :
            {
               HFILE fout;
               char  copybuffer[512];
               long  copysize;
               int   realsize;

               printf("Extraction du fichier ..."); fflush(stdout);

               fout=_lcreat(tar_header.name,0);
               if (fout!=HFILE_ERROR)
               {
                  copysize=tar_chuncksize(tar_header);
                  while (copysize>0)
                  {
                     if (copysize>=512)
                        realsize=512;
                     else
                        realsize=copysize;

                     if (_lread (ftar,copybuffer,realsize)!=realsize) return 0;
                     if (_lwrite(fout,copybuffer,realsize)!=realsize) return 0;

                     copysize-=realsize;
                  }

                  _lclose(fout);

                  if (!tar_adjust_seek(ftar,tar_chuncksize(tar_header)))
                  {
                     printf("4TAR erreur : Seeking error !\n");
                     return 0;
                  }
               }
               else
               {
                  printf("4TAR erreur : impossible d'ouvrir le fichier de sortie !\n");
                  return 0;
               }

               printf("  Ok.\n");
            }
            break;

         default :
            printf("*** Type de fichier non support !\n"); fflush(stdout);
            break;
      }
   }
   return 1;
}
#else
int tar_add_desc(char *index, char *description)
{
   FILE *desc;

   desc=fopen("descript.ion","a+");
   if (desc)
   {
      fprintf(desc,"%s %s\n",index,description);
      fclose(desc);
      _dos_setfileattr("descript.ion",FA_HIDDEN);
   }
   else
      return 0;

   return 1;
}

/* Recursive function ! */
int tar_extract(FILE *ftar)
{
   static char currentdir[256]="";
   int count_dir=0;
   int count_file=0;

   while (tar_readheader(ftar,&tar_header)&&(tar_header.name[0]!=0))
   {
      printf("%s: ",tar_header.name); fflush(stdout);

      switch (tar_header.linkflag)
      {
         case LF_DIR :
            {
               char index[13];
               int  walk;

               printf("Cration du rpertoire ...");

               sprintf(index,"%08i.DIR",count_dir++);
               if (!tar_add_desc(index,tar_header.name+strlen(currentdir)))
                  return 0;

               if (mkdir(index)||chdir(index))
               {
                  printf("4TAR erreur : Erreur de repertoire !\n");
                  return 0;
               }
               strcpy(currentdir,tar_header.name);
               printf(" Ok.\n");

               if (!tar_extract(ftar)) /* Recursive call */
                  return 0;

               chdir("..");
               walk=strlen(currentdir);
               while ((walk>=0)&&(currentdir[walk]!='/'))
                  walk--;
               currentdir[walk+1]=0;
            }
            break;

         case LF_OLDNORMAL :
         case LF_NORMAL :
            {
               FILE *fout;
               char  index[13];
               char  copybuffer[512];
               long  copysize;
               int   realsize;

               printf("Extraction du fichier ..."); fflush(stdout);

               sprintf(index,"%08i.FIC",count_file++);
               if (!tar_add_desc(index,tar_header.name+strlen(currentdir)))
                  return 0;

               fout=fopen(index,"wb");
               if (fout)
               {
                  copysize=tar_chuncksize(tar_header);
                  while (copysize>0)
                  {
                     if (copysize>=512)
                        realsize=512;
                     else
                        realsize=copysize;

                     if (fread (copybuffer,1,realsize,ftar)!=realsize) return 0;
                     if (fwrite(copybuffer,1,realsize,fout)!=realsize) return 0;

                     copysize-=realsize;
                  }

                  fclose(fout);

                  if (!tar_adjust_seek(ftar,tar_chuncksize(tar_header)))
                  {
                     printf("4TAR erreur : Seeking error !\n");
                     return 0;
                  }
               }
               else
               {
                  printf("4TAR erreur : impossible d'ouvrir le fichier de sortie !\n");
                  return 0;
               }

               printf("  Ok.\n");
            }
            break;

         default :
            printf("*** Type de fichier non support !\n"); fflush(stdout);
            break;
      }
   }
   return 1;
}
#endif






void tar_dir(TARFILE ftar)
{
   while (tar_readheader(ftar,&tar_header)&&(tar_header.name[0]!=0))
   {
      puts(tar_header.name);

      if (!tar_relative_seek(ftar,tar_chuncksize(tar_header)))
      {
         printf("%s erreur : Seeking error !\n",PROGNAME);
         return;
      }
   }
}






int main(int argc, char **argv)
{
   TARFILE ftar;
   char *commande;

#ifdef __WIN32__
   printf("\nTAR for Windows 95/NT");
#else
   printf("\nTAR for 4DOS with descriptions");
#endif
   puts(" - v0.3b - (c)1996 HERQUE Frdric\n");

   if (argc==3)
   {
      commande=strchr("dDxX",argv[1][0]);
      if (commande)
      {
          ftar=tar_openfile(argv[2],0);
          if (ftar)
          {
             switch (commande[0])
             {
                case 'd' :
                case 'D' :
                   tar_dir(ftar);
                   break;

                case 'x' :
                case 'X' :
                   tar_extract(ftar);
                   break;
             }
             tar_closefile(ftar);
          }
      }
      else
         printf("%s erreur: commande inconnue (%s) !\n",PROGNAME,argv[1]);
   }
   else
   {
      printf("Syntaxe :\n"
             "\n"
             "   %s d fichier.tar\n"
             "     pour lister le rpertoire de l'archive.\n"
             "\n"
             "   %s x fichier.tar\n"
             "     pour extraire l'archive en plaant les\n"
             "     noms longs au format "
#ifdef __WIN32__
             "Windows 95.\n\n"
#else
             "des descriptions 4DOS.\n\n"
#endif
             ,PROGNAME,PROGNAME);
   }

   return 0;
}

